#include "FSUtils.h"
#include "CDesktop.h"
#include "CDesktopWindow.h"
#include "A2PixInterface.h"
#include "Utils.h"
#include "IC_Main.h"

/********************************************
	This routine gets called for each item (which could be either a file or a folder)
	that the caller wants dropped.  The determining factor is the definition of the 
	qWalkFolder compiler directive.   Either way, the item in question should be
	processed as a single item and not "dissected" into component units (like subfiles
	of a folder!), the recursive dissection happens at a higher level.
*/

#define	kMaxDisksAtOnce		32
FSSpec	g_fsSpecArray[kMaxDisksAtOnce];

short	g_numDisks	 			= 0;
Boolean	g_has_pending_mountB	= FALSE;

OSErr ProcessItem(FSSpecPtr myFSSPtr);
OSErr ProcessItem(FSSpecPtr myFSSPtr) 
{
	g_has_pending_mountB		= TRUE;
	g_fsSpecArray[g_numDisks++] = *myFSSPtr;
	return(noErr);
}

#define	Gen_OpenFSSpec(_a, _b, _c)	false

void	MountPending(void);
void	MountPending(void)
{
	if (g_has_pending_mountB) {
		short		loop;
		short		maxLoop = g_numDisks;
		OSErr		err = noErr;
		Boolean		mountB;
		FInfo		finderInfo;
		FSSpec		*fileSpecP;
		
		SetStandardCursor(watchCursor);
		g_has_pending_mountB	= FALSE;
		g_numDisks				= 0;
		
		gDesktop->i_desktopWindow->DeSelectAll();
		gDesktop->i_desktopWindow->i_deselectB = FALSE;
		
		for (loop = 0; loop < maxLoop; loop++) {
			fileSpecP = &g_fsSpecArray[loop];
			
			mountB = TRUE;
			
			err = FSpGetFInfo(fileSpecP, &finderInfo);
			if (!err) {
				if (Gen_OpenFSSpec(
					finderInfo.fdType == kGenFileType ? Gen_GetFile_ROSE : Gen_GetFile_TEXT, 
					finderInfo.fdType, fileSpecP
				) != false) {
					mountB = FALSE;
				} else if (
					finderInfo.fdType == A2Pix_FileType1
					|| finderInfo.fdType == A2Pix_FileType2
					|| finderInfo.fdType == A2Pix_FileType3
				) {
					mountB = FALSE;
					
					finderInfo.fdCreator = A2Pix_Creator;
					
					err = FSpSetFInfo(fileSpecP, &finderInfo);
					if (!err) err = FSpLaunchInFinder(fileSpecP);
				}
			}
			
			if (mountB) {
				DiskDeviceRec	*deviceP;
				
				err = NewDeviceRec(
					DiskType_inMemory_Raw, fileSpecP, &deviceP);
				
				if (!err) {
					err = gDesktop->MountDisk(deviceP);
					
					if (err && deviceP->refCountS == 0) {
						TrackDisposePtr((Ptr)deviceP);
					}
				}
			}
		}
		
		gDesktop->i_desktopWindow->UpdateSort(FALSE);
		gDesktop->i_desktopWindow->i_deselectB = TRUE;
	}
}
